unit wserver;

interface

uses
   sysutils, forms, messages, Classes, Controls, StdCtrls,
   WapCalls;

   // WapCalls is included in the Uses clause
   // to declare the Wapapi procedures

type
  TWapSrv = class(TForm)
    Label1: TLabel;
    THitLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    iiHits  :integer;
  public
    procedure WebRequest(var msg: TMessage); message wm_User + 1;
  end;

var
  WapSrv: TWapSrv;

implementation
{$R *.DFM}



procedure TWapSrv.FormCreate(Sender: TObject);
var
  liRet      :integer;
begin
   liRet := StartServing(handle, wm_user + 1, '0.0.0.0', 80);
   EnableLogging('wapserve.log', TRUE, 250);
   if liRet <> 1 then
     THitLabel.Caption := 'Could not start Wapapi: ' + IntToStr(liRet);
   iiHits := 0;
end;

procedure TWapSrv.FormDestroy(Sender: TObject);
begin
   StopServing();
end;

// WebRequest:  this is a user-defined event on the form that
//              has been hooked to a window's message.
//              the message number: wm_User + 1 has been used
//              but any number above 1024 (wm_User) may be used, as long
//              as the same event number that is used to declare the
//              user event is passed to Wapapi in the StartServing call.
//
procedure TWapSrv.WebRequest(var msg :TMessage);
var
  lbparms, lbSuccess                        :boolean;
  lpDoc, pName, pValue                      :pchar;
  liRet, liParms, liParm                    :integer;
  llHandle                                  :longint;
  lSize, lAlloc1, lAlloc2                   :longint;
  iFlags                                    :integer;
begin
   lpDoc := StrAlloc(512);
   liRet := GetDocName(lpDoc, liParms);
   if (lpDoc='\') or (lpDoc = '') then StrPCopy(lpDoc, 'index.htm');
   if Pos('.', lpDoc) = 0 then lpDoc := StrCat(lpDoc, '.htm');

   // Example of reading a parameter (name: field1 used as an example)
   //
   // if liParms > 0 then
   // begin
   //    pName := StrAlloc(100);
   //    pValue := StrAlloc(1024);
   //    StrPCopy(pName, 'field1');
   //    liret := GetParmString(pName, pValue);
   //    StrDispose(pName);
   //    StrDispose(pValue);
   // end;

   // For this example, assume every hit is a file
   //
   liRet := SendDocument(lpDoc);
   StrDispose(lpDoc);
   Inc(iiHits);
   THitLabel.Caption := IntToStr(iiHits);
   THitLabel.Refresh();
   // Example of building a document dynamically & sending it
   //  back to the requestor
   //
   //  pText := StrAlloc(100);
   //  StrPCopy(pText, '<html><body>');
   //  BufferText(pText);
   //  StrPCopy(pText, 'Hello World');
   //  BufferText(pText);
   //  StrPCopy(pText, '</body></html>');
   //  BufferText(pText);
   //  SendText;
end;

end.
